package com.qboxus.tictic.adapters

import android.util.Log
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.sendgift.GiftHistoryModel
import com.qboxus.tictic.databinding.ItemVideoGiftBinding
import com.qboxus.tictic.simpleclasses.Functions.frescoImageLoad

/**
 * Created by yurr on 3/20/2018.
 */
class VideoGiftsAdapter(
    val datalist: ArrayList<GiftHistoryModel>
) : RecyclerView.Adapter<VideoGiftsAdapter.CustomViewHolder>() {

    override fun onCreateViewHolder(viewGroup: ViewGroup, viewtype: Int): CustomViewHolder {
        val binding:ItemVideoGiftBinding =DataBindingUtil.inflate(LayoutInflater.from(viewGroup.context),
            R.layout.item_video_gift, viewGroup, false)
        return CustomViewHolder(binding)
    }

    override fun getItemCount(): Int {
        return datalist.size
    }

    override fun onBindViewHolder(holder: CustomViewHolder, position: Int) {
        val item = datalist.get(position)

        if (item.gift.icon!!.isEmpty()){
            holder.binding.userImage.controller = frescoImageLoad(
                "${item.gift.image}", R.drawable.ic_user_icon, holder.binding.userImage, false)
            Log.d(Constants.tag,"image gift :${item.gift.image}")
        }else{
            holder.binding.userImage.controller = frescoImageLoad(
                "${item.gift.icon}", R.drawable.ic_user_icon, holder.binding.userImage, false)
            Log.d(Constants.tag,"icon gift :${item.gift.icon}")
        }


    }

    inner class CustomViewHolder(val binding: ItemVideoGiftBinding) : RecyclerView.ViewHolder(
        binding.root) {

    }


}